<?php

require_once('paykeeper.class.php');

class paykeeperPayment extends payment
{
    public function validate()
    {
        return true;
    }

    /** @inheritDoc */
    public static function getOrderId()
    {
        return (int) getRequest('service_name');
    }

    public function process($template = null)
    {
        $order = $this->order;

        /** Сохраняем заказ в базе со статусом "в обработке"(waiting) */

        $order->order();

        /** Получение данных текущего пользователя */

        $userObject = customer::get();
        $fname = !empty($userObject->getValue("fname")) ? $userObject->getValue("fname") : '';
        $lname = !empty($userObject->getValue("lname")) ? $userObject->getValue("lname") : '';
        $login = !empty($userObject->getValue("login")) ? $userObject->getValue("login") : '';
        $client_email = !empty($userObject->getValue("email")) ? $userObject->getValue("email") : '';
        $client_phone = !empty($userObject->getValue("phone")) ? $userObject->getValue("phone") : '';
        $clientid = trim($fname . ' ' . $lname . ' ' . $login);

        /** Получаем номер заказа - не путать с идентификатором */

        $orderid = $order->getNumber();
        $service_name = $order->getId();

        /** Полная сумма заказа */

        $total_sum	= number_format($order->getActualPrice(), 2, '.', '');

        /** Настройки модуля */

        $payment_form_url = $this->object->payment_form_url;
        $secret_key = $this->object->secret_key;

        /** Заполняем объект вспомогательного класса */

        $pk_obj = new Paykeeper();

        //set order params
        $pk_obj->setOrderParams(
            $total_sum, // sum
            $clientid, // clientid
            $orderid, // orderid
            $client_email, // client_email
            $client_phone, // client_phone
            $service_name, // service_name
            $payment_form_url, // payment form url
            $secret_key // secret key
        );

        /** Получаем корзину */

        $items = $order->getItems();

        /** Парсим корзину, заполняем вспомогательный объект */

        $last_index = 0;

        /** Получаем объект umi для извлечения данных об НДС,предмете расчета, доставке, скидках */

        $objects = umiObjectsCollection::getInstance();

        foreach ($items as $item) {
            $userObject = $objects->getObject($item->getTaxRateId());
            $tax_rate = $userObject->getValue('tax');
            if ($tax_rate != 'none') {
                $pk_obj->setUseTaxes();
            }
            $payment_subject = $objects->getObject($item->getPaymentSubjectId());
            switch ($payment_subject->getName()) {
                case 'Товар':
                    $item_type = 'goods';
                    break;
                case 'Подакцизный товар':
                    $item_type = 'excise';
                    break;
                case 'Работа':
                    $item_type = 'work';
                    break;
                case 'Услуга':
                    $item_type = 'service';
                    break;
                default:
                    $item_type = '';
                    break;
            }

            $name = $item->getName();
            $price = number_format($item->getActualPrice(),2,'.','');
            $quantity = $item->getAmount();

            if ($quantity == 1 && $pk_obj->single_item_index < 0) {
                $pk_obj->single_item_index = $last_index;
            }
            if ($quantity > 1 && $pk_obj->more_then_one_item_index < 0) {
                $pk_obj->more_then_one_item_index = $last_index;
            }

            $taxes = $pk_obj->setTaxes($tax_rate);
            $pk_obj->updateFiscalCart(
                $pk_obj->getPaymentFormType(),
                $name,
                $price,
                $quantity,
                0,
                $taxes["tax"]
            );
            if ($item_type) {
                $pk_obj->fiscal_cart[$last_index]['item_type'] = $item_type;
            }
            $last_index++;
        }

        if ($order->getDeliveryPrice() > 0) {
            $pk_obj->setUseDelivery();
            $pk_obj->setShippingPrice(number_format($order->getDeliveryPrice(),2,',',''));
            $delivery_id = $order->getDeliveryId();
            $delivery = $objects->getObject($delivery_id);
            $delivery_name = $delivery->getName();
            $pk_obj->updateFiscalCart(
                $pk_obj->getPaymentFormType(),
                $delivery_name,
                $pk_obj->getShippingPrice(),
                1,
                0
            );
            $pk_obj->fiscal_cart[$last_index]['item_type'] = 'service';
            $pk_obj->delivery_index = $last_index;
        }

        if ($order->getDiscountValue() > 0) {
            $pk_obj->setDiscounts(true);
        }

        $pk_obj->correctPrecision();

        /** Устанавливаем статусы платежа */

        $order->setPaymentStatus('initialized');

        $form = "";
        if ($pk_obj->getPaymentFormType() == "create") { //create form
            $to_hash = number_format($pk_obj->getOrderTotal(), 2, ".", "") .
                $pk_obj->getOrderParams("clientid")     .
                $pk_obj->getOrderParams("orderid")      .
                $pk_obj->getOrderParams("service_name") .
                $pk_obj->getOrderParams("client_email") .
                $pk_obj->getOrderParams("client_phone") .
                $pk_obj->getOrderParams("secret_key");
            $sign = hash ('sha256' , $to_hash);
            $form = '
                    <h3>Сейчас Вы будете перенаправлены на страницу банка.</h3> 
                    <form name="payment" id="pay_form" action="'.$pk_obj->getOrderParams("form_url").'" accept-charset="utf-8" method="post">
                    <input type="hidden" name="sum" value = "'.$pk_obj->getOrderTotal().'"/>
                    <input type="hidden" name="orderid" value = "'.$pk_obj->getOrderParams("orderid").'"/>
                    <input type="hidden" name="clientid" value = "'.$pk_obj->getOrderParams("clientid").'"/>
                    <input type="hidden" name="client_email" value = "'.$pk_obj->getOrderParams("client_email").'"/>
                    <input type="hidden" name="client_phone" value = "'.$pk_obj->getOrderParams("client_phone").'"/>
                    <input type="hidden" name="service_name" value = "'.$pk_obj->getOrderParams("service_name").'"/>
                    <input type="hidden" name="cart" value = \''.htmlentities($pk_obj->getFiscalCartEncoded(),ENT_QUOTES).'\' />
                    <input type="hidden" name="sign" value = "'.$sign.'"/>
                    <input type="submit" id="button-confirm" value="Оплатить"/>
                    </form>
                    <script type="text/javascript">
                    window.addEventListener("load", submitPayForm);
                    function submitPayForm() {
                        setTimeout(function() {
                            document.getElementById("pay_form").submit();
                        }, 2000);
                    }
                    </script>';
        } else {
            throw new Exception("Модуль не поддерживает методов оплаты, кроме /create ");
        }

        $param = array();
        $param['payment_form'] = $form;

        list($templateString) = def_module::loadTemplates("emarket/payment/paykeeper/".$template, "form_block");

        $ret_value = def_module::parseTemplate($templateString, $param);

        return $ret_value;
    }

    public function poll()
    {
        ob_end_clean();
        $buffer = outputBuffer::current();
        $buffer->clear();
        $buffer->contentType('text/plain');
        $the_Id	= getRequest('id');
        $the_Sum = getRequest('sum');
        $the_Clientid = getRequest('clientid');
        $the_Orderid = intval(getRequest('orderid'));
        $the_Key = getRequest('key');

        $our_key = $this->object->secret_key;

        $our_signature = md5($the_Id . number_format((float)$the_Sum, 2, '.', '') . $the_Clientid . $the_Orderid . $our_key);

        // check transaction signature
        if ($the_Key != $our_signature) {
            die('Message digest incorrect');
        }

        //change order status
        $this->order->setPaymentStatus('accepted');

        $this->order->payment_document_num = $the_Id;
        $order_status = $this->object->order_status;

        if (isset($order_status)) {
            $this->order->setOrderStatus($order_status);
        }

        $our_hash = md5($the_Id . $our_key);

        $buffer->push("OK $our_hash");
        $buffer->end();
    }
};
?>